/* <nagg10.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g10 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2159 (Feb 1998).
 * Mark 6 revised. IER-3046 (July 2000).
 */
#ifndef NAGG10
#define NAGG10

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
//#include <nag_stddef.h>  //Cheney 2006-6-5
#include "nag_stddef.h"
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g10abc(Nag_SmoothFitType mode, Integer n, const double x[],
                     const double y[], const double wt[], double rho, double yhat[],
                     double c[], double *rss, double *df,
                     double res[], double h[], double wk[], NagError *fail);
  extern void g10abf_f(char *mode, char *weight, Integer n, const double x[],
                       const double y[], const double wt[], double rho, double yhat[],
                       double c[], Integer ldc, double *rss, double *df,
                       double res[], double h[], double wk[], Integer *ifail,
                       Integer mode_len, Integer weight_len);
  extern void g10abw_f(const double x[], double avh, Integer n, double r[],
                       double p, double h[], const double w[]);
  extern void g10abx_f(const double x[], double avh, const double y[], const double dy[],
                       Integer n, double q, const double yhat[], double c[],
                       Integer ldc, double su[], const double sv[]);
  extern void g10aby_f(const double x[], double avh, const double dy[], Integer n,
                       double rho, double *p, double *q, double *rss,
                       double *df, const double u[], const double c[], Integer ldc,
                       double r[], const double t[], double su[], double res[]);
  extern void g10abz_f(char *weight, const double x[], double *avh, const double y[],
                       const double wt[], double *avdy, Integer n, double wwt[],
                       double u[], double c[], Integer ldc, double r[],
                       double t[], Integer *ierror, Integer weight_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g10acc(Nag_SmoothParamMethods method, Integer n, const double x[],
                     const double y[], const double wt[], double yhat[], double c[],
                     double *rss, double *rdf, double res[],
                     double h[], double *crit, double *rho, double u,
                     double tol, Integer maxcal, NagError *fail);
  extern void g10acf_f(char *method, char *weight, Integer n, const double x[],
                       const double y[], const double wt[], double yhat[], double c[],
                       Integer ldc,  double *rss, double *rdf, double res[],
                       double h[], double *crit, double *rho, double u,
                       double tol, Integer *maxcal, double wk[], Integer *ifail,
                       Integer method_len, Integer weight_len);
  extern void g10acx_f(double u, double tol, Integer maxcal, double crit,
                       double *rho, const double x[], double avh, const double wwt[],
                       Integer n, double *p, double *q, const double yhat[],
                       const double c[], Integer ldc, double wk[], double res[],
                       double d[], Integer *ierror);
  extern double g10acy_f(Integer ind, double rho, const double x[], double avh,
                         const double wt[], Integer n, double *p, double *q,
                         const double y[], const double c[], Integer ldc, double r[],
                         const double s[], double su[], double res[]);
  extern void g10acz_f(double upper, double tol, Integer *maxcal, Integer ind,
                       double *rho, double *crit, const double x[], double avh,
                       const double wt[], Integer n, double *p, double *q,
                       const double yhat[], const double c[], Integer ldc, double r[],
                       const double s[], double su[], double res[], Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL g10bac(Integer n, const double x[], double window, double slo,
                     double shi, Integer ns, double smooth[], double t[],
                     NagError *fail);
  extern void g10baf_f(Integer n, const double x[], double window, double slo,
                       double shi, Integer ns, double smooth[], double t[],
                       Boolean usefft, double fft[], Integer *ifail);
  extern void g10bbc(Nag_Smooth_Type smoother, Integer n, double y[], double smooth[],
                     double rough[], NagError *fail);
  extern void g10bbo(double y[], Integer n, Integer m, double run[], Integer ind[]);
  extern void g10bbp(double x1, double x2, double x3, double *xmed,
                     Boolean * change);
  extern void g10bbq(double y[], Integer n, Boolean *change);
  extern void g10bbr(double y[], Integer n);
  extern void g10bbs(double y[], Integer n);
  extern void g10bbt(double y[], Integer n);
  extern void g10bbu(double y[], Integer n, double work[]);
  extern void g10bbv(double y[], Integer n, double *endsav, double work[]);
  extern void g10bbw(double y[], Integer  n, Boolean *change);
  extern void g10bbx(double y[], Integer n, double endsav);
  extern void g10bby(double y[], Integer n);
  extern void g10bbz(double y[], Integer n);
  extern NAG_DLL_EXPIMP void NAG_CALL g10cac(Nag_Smooth_Type smoother, Integer n, double y[], double smooth[],
                                             double rough[], NagError *fail);
  extern void g10caf_f(Integer itype, Integer n, const double y[], double smooth[],
                       double rough[], Integer *ifail);
  extern void g10can_f(double y[], Integer n, Integer m, double run[],
                       Integer ind[]);
  extern void g10cao(double y[], Integer n, Integer m, double run[], size_t ind[]);
  extern void g10cap_f(double x1, double x2, double x3, double *xmed,
                       Boolean *change);
  extern void g10cap(double x1, double x2, double x3, double *xmed,
                     Boolean * change);
  extern void g10caq_f(double y[], Integer n, Boolean *change);
  extern void g10caq(double y[], Integer n, Boolean *change);
  extern void g10car_f(double y[], Integer n);
  extern void g10car(double y[], Integer n);
  extern void g10cas_f(double y[], Integer n);
  extern void g10cas(double y[], Integer n);
  extern void g10cat_f(double y[], Integer n);
  extern void g10cat(double y[], Integer n);
  extern void g10cau_f(double y[], Integer n, double work[]);
  extern void g10cau(double y[], Integer n, double work[]);
  extern void g10cav_f(double y[], Integer n, double *endsav, double work[]);
  extern void g10cav(double y[], Integer n, double *endsav, double work[]);
  extern void g10caw_f(double y[], Integer n, Boolean *change);
  extern void g10caw(double y[], Integer  n, Boolean *change);
  extern void g10cax_f(double y[], Integer n, double endsav);
  extern void g10cax(double y[], Integer n, double endsav);
  extern void g10cay_f(double y[], Integer n);
  extern void g10cay(double y[], Integer n);
  extern void g10caz_f(double y[], Integer n);
  extern void g10caz(double y[], Integer n);
  extern NAG_DLL_EXPIMP void NAG_CALL g10zac(Integer n, const double x[], const double y[],
                     const double wt[], Integer *nord, double xord[], double yord[],
                     double wwt[], double *rss, NagError *fail);
  extern void g10zaf_f(char *weight, Integer n, const double x[], const double y[],
                       const double wt[], Integer *nord, double xord[], double yord[],
                       double wwt[], double *rss, Integer iwrk[], Integer *ifail,
                       Integer weight_len);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG10 */
